//AIM: Compute skin depth and ac & dc resistance of a wire at given frequency.
//Software version Scilab 5.5.2
//OS Windows 7

clc;
clear;
//Now let us consder 1GHz and 10GHz be the given frequencies
//Let the kength of the wire be 10cm with a diameter of 1mm
Length=10*(10^-2);//in metres
a=0.5*(10^-3);//Since diameter is 1mm,so the radius 'a' will be 0.5*10^-3 metres
sigmacu=64.516*10^6;//in mho/metres
sigmaAl=40*10^6;//in mho/metres
sigmaAu=48.544*10^6;//in mho/metres
//sigmacu,sigmaAl,sigmaAu are the conductivities of copper,aluminium 
//and gold respectively.
//The formula for skin depth is 1/sqrt(%pi*f*mu0*sigma)
//Since we have to calculate the skin depth for 3 values of frequency
// & 3 values of sigma,we will first calculate the value of 
//1/sqrt(%pi*mu0) only which will be required for initial calculations
mu0=4*%pi*(10^(-7));//Standard value of permeability of free space (in H/m)
b=inv(sqrt(%pi*mu0));
//(i)At 1GHz 
f1=1*(10^9);//in Hz
skindepthcu=b/(sqrt(f1*sigmacu));
skindepthAl=b/(sqrt(f1*sigmaAl));
skindepthAu=b/sqrt((f1*sigmaAu))
Rdccu=Length/(%pi*a*a*sigmacu)
RdcAl=Length/(%pi*a*a*sigmaAl);
RdcAu=Length/(%pi*a*a*sigmaAu);
Raccu=(Rdccu*a)/(2*skindepthcu);
RacAl=(RdcAl*a)/(2*skindepthAl);
RacAu=(RdcAu*a)/(2*skindepthAu);
disp("At 1GHz")
printf("Skindepth for Cu,Al,Au is as shown respectively=\n%g m\n%g m\n%g m\n",skindepthcu,skindepthAl,skindepthAu)
printf("DC resistance for Cu,Al,Au is as shown respectively=\n%g ohms\n%g ohms\n%g ohms\n",Rdccu,RdcAl,RdcAu)
printf("AC resistance for Cu,Al,Au is as shown respectively=\n%g ohms\n%g ohms\n%g ohms\n",Raccu,RacAl,RacAu)
//(ii)At 10GHz
f2=10*10^9;//in Hz
skindepthcu2=b/(sqrt(f2*sigmacu));
skindepthAl2=b/sqrt((f2*sigmaAl));
skindepthAu2=b/sqrt((f2*sigmaAu));
Raccu=Rdccu*a/(2*skindepthcu2);
RacAl=RdcAl*a/(2*skindepthAl2);
RacAu=RdcAu*a/(2*skindepthAu2);
disp("At 10GHz")
printf("skindepth for Cu,Al,Au is as shown respectively=\n%g m\n%g m\n%g m\n",skindepthcu2,skindepthAl2,skindepthAu2)
printf("AC resistance for Cu,Al,Au is as shown respectively=\n%g ohms\n%g ohms\n%g ohms",Raccu,RacAl,RacAu)
